using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using hiveAdiz;

public class HiveAdizManager : MonoBehaviour
{

    // delegate format
    public delegate void onAdizManagerEvent(bool isSuccess, string message);

    // delegate list
    // HIVE SDK AuthV4 delegates
    static onAdizManagerEvent onAdizManagerInit;

    private const string TAG = "HiveAdizManager";

    static HiveAdizManager _instance = null;	// 싱글톤 객체
    private static object _syncobj = new object();
	private static bool appIsClosing = false;

    AdizAppOpen appOpenAd;
    AdizBanner banner;
    AdizRewarded rewarded;

    // Start is called before the first frame update
    void Start()
    {
        
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    static public HiveAdizManager shared {
		get {
            if (appIsClosing)
                return null;

			lock (_syncobj)  
            {  
				if (_instance == null) {
					_instance = FindObjectOfType<HiveAdizManager> ();
					if (_instance == null) {
						//create gameobject and add component postbox
						GameObject obj = new GameObject ();
						obj.name = "HiveAdizManager";
						_instance = obj.AddComponent<HiveAdizManager> ();
						DontDestroyOnLoad (obj);
					}
				}
			}
			return _instance;
		}
    }

    protected virtual void OnApplicationQuit()
    {
        // release reference on exit
        appIsClosing = true;
    }

    public void InitPlugin() {
        Adiz.InitPlugin();
    }

    public void AdizInitialize(onAdizManagerEvent listener) {

        // Adiz.SetZone((int)ZoneType.TEST);
        // Adiz.SetTestMode(true);
        // Adiz.SetLogEnable(true);
        #if !UNITY_EDITOR
            #if UNITY_ANDROID
            // Adiz.SetTestDevice("D3A8A59D60495B231348403855E583DD");
            #else
            // Adiz.SetTestDevice("");
            #endif
        #endif

        onAdizManagerInit = listener;
        Adiz.Initialize(new CommonHandlers.Builder()
                                        .OnResult(InitResultCB)
                                        .Build());
    }

    public void SetLogEnable(bool enable) {
        Adiz.SetLogEnable(enable);
    }

    public void SetTestZone(bool enable)
    {
        if (enable) {
            Adiz.SetZone((int)ZoneType.TEST);
        } else {
            Adiz.SetZone((int)ZoneType.REAL);
        }
    }

    public void ReadyAds()
    {
        if (onAdizManagerInit != null)
        {
            readyAppOpen();
            readyBanner();
            onAdizManagerInit = null;
        }
    }

    private void InitResultCB(AdizError error, string jsonString) {
        Debug.Log(TAG + "::InitResultCB:: errorCode : "+error.errorCode+" errorMessage : "+error.errorMessage+" json : "+jsonString);

        if (onAdizManagerInit != null)
        {
            onAdizManagerInit(error.isSuccess(), jsonString);
        }

        if(error.isSuccess()) {
            Debug.Log(TAG + "::InitResultCB:: success");
        }
    }

#region AppOpen
    public void readyAppOpen(AdEventHandlers eventHandlers = null) {
        if(eventHandlers == null) {
            eventHandlers = new AdEventHandlers.Builder()
                                                .OnAdLoad(OnAppOpenLoadCB)
                                                .OnAdFail(OnAppOpenFailCB)
                                                .OnAdClose(OnAppOpenCloseCB)
                                                .Build();

        }
        
        appOpenAd = AdizAppOpen.Initialize(eventHandlers);
        if(appOpenAd != null) appOpenAd.Load();
    }

    private void OnAppOpenLoadCB() {
        Debug.Log(TAG + "::OnAppOpenLoadCB");
    }

    private void OnAppOpenFailCB(AdizError error) {
        Debug.Log(TAG + "::OnAppOpenLoadCB errorCode "+error.errorCode);
        Debug.Log(TAG + "::OnAppOpenLoadCB errorMessage "+error.errorMessage);
    }

    private void OnAppOpenCloseCB() {
        Debug.Log(TAG + "::OnAppOpenCloseCB");
        if(appOpenAd != null) appOpenAd.Load();
    }
#endregion

#region Banner
    public void readyBanner(AdEventHandlers eventHandlers = null) {
        if(eventHandlers == null) {
            eventHandlers = new AdEventHandlers.Builder()
                                                .OnAdLoad(OnBannerLoadCB)
                                                .OnAdFail(OnBannerFailCB)
                                                .OnAdClose(OnBannerCloseCB)
                                                .Build();
        }

        banner = AdizBanner.Initialize(BannerSize.NORMAL, eventHandlers);
        if(banner != null) banner.Load();
    }

    public AdizBanner GetAdizBanner() {
        return banner;
    }

    private void OnBannerLoadCB() {
        Debug.Log(TAG + "::OnBannerLoadCB");
        if(banner != null) banner.Show();
    }

    private void OnBannerFailCB(AdizError error) {
        Debug.Log(TAG + "::OnBannerFailCB errorCode "+error.errorCode);
        Debug.Log(TAG + "::OnBannerFailCB errorMessage "+error.errorMessage);
    }

    private void OnBannerCloseCB() {
        Debug.Log(TAG + "::OnBannerCloseCB");
        if(banner != null) banner.Load();
    }
#endregion

#region Reward
    public void readyReward(AdEventHandlers eventHandlers = null) {
        if(eventHandlers == null) {
            eventHandlers = new AdEventHandlers.Builder()
                                                .OnAdLoad(OnRewardeLoadCB)
                                                .OnAdFail(OnRewardeFailCB)
                                                .OnAdClose(OnRewardeCloseCB)
                                                .OnAdReward(OnRewardeRewardCB)
                                                .Build();
        }

        rewarded = AdizRewarded.Initialize(eventHandlers);
        if(rewarded != null) rewarded.Load();
    }

    public AdizRewarded GetAdizRewarded() {
        return rewarded;
    }

    private void OnRewardeLoadCB() {
        Debug.Log(TAG + "::OnRewardeLoadCB");
        if(rewarded != null) rewarded.Show();
    }

    private void OnRewardeFailCB(AdizError error) {
        Debug.Log(TAG + "::OnRewardeFailCB errorCode "+error.errorCode);
        Debug.Log(TAG + "::OnRewardeFailCB errorMessage "+error.errorMessage);
    }

    private void OnRewardeCloseCB() {
        Debug.Log(TAG + "::OnRewardeCloseCB");
        if(rewarded != null) rewarded.Load();
    }

    private void OnRewardeRewardCB(RewardItem item) {
        Debug.Log(TAG + "::OnRewardeRewardCB item type "+item.getItemType() + " amount " + item.getItemAmount());
    }
    
#endregion

}